DROP VIEW IF EXISTS softsat_locacao_veiculo_manutencao;
CREATE VIEW softsat_locacao_veiculo_manutencao AS
SELECT 
	`vei`.`id` AS `id`,
	`vei`.`created_on` AS `created_on`,
	`vei`.`updated_on` AS `updated_on`,
	`vei`.`created_by` AS `created_by`,
	`vei`.`updated_by` AS `updated_by`,
	`vei`.`nome` AS `nome`,
	`vei`.`descricao` AS `descricao`,
	`vei`.`placa` AS `placa`,
	`vei`.`marca_id` AS `marca_id`,
	`vei`.`modelo` AS `modelo`,
	`vei`.`ano` AS `ano`,
	`vei`.`ano_modelo` AS `ano_modelo`,
	`vei`.`combustivel_id` AS `combustivel_id`,
	`vei`.`chassi` AS `chassi`,
	`vei`.`grupo_id` AS `grupo_id`,
	`vei`.`imagem` AS `imagem`,
	`vei`.`tarifa_id` AS `tarifa_id`,
	`vei`.`km_atual` AS `km_atual`,
	`vei`.`km_oleo` AS `km_oleo`,
	`vei`.`data_oleo` AS `data_oleo`,
	`vei`.`km_pastilha` AS `km_pastilha`,
	`vei`.`data_pastilha` AS `data_pastilha`,
	`vei`.`km_pneu` AS `km_pneu`,
	`vei`.`data_pneu` AS `data_pneu`,
	`vei`.`ativo` AS `ativo`,
	`vei`.`situacao_frente` AS `situacao_frente`,
	`vei`.`situacao_traseira` AS `situacao_traseira`,
	`vei`.`situacao_direita` AS `situacao_direita`,
	`vei`.`situacao_esquerda` AS `situacao_esquerda`,
	`vei`.`situacao_superior` AS `situacao_superior`,
	`vei`.`situacao_inferior` AS `situacao_inferior`,
	`vei`.`ano_licenciamento` AS `ano_licenciamento`,
	`vei`.`grupo` AS `grupo`,
	`vei`.`marca` AS `marca`,
	`vei`.`combustivel` AS `combustivel`,
	`vei`.`tarifa` AS `tarifa`,
	(((`vei`.`km_atual` - `vei`.`km_oleo`) > `skm_oleo`.`value`) OR ((TO_DAYS(CURDATE()) - TO_DAYS(`vei`.`data_oleo`)) > `sdias_oleo`.`value`)) AS `manutencao_oleo`,
	(`vei`.`km_atual` - `vei`.`km_oleo`) AS `km_oleo_percorrido`,(TO_DAYS(CURDATE()) - TO_DAYS(`vei`.`data_oleo`)) AS `dias_oleo_percorrido`,
	((`vei`.`km_atual` - `vei`.`km_pastilha`) > CAST(`skm_past`.`value` AS DECIMAL(10,0))) AS `manutencao_pastilha`,
	(`vei`.`km_atual` - `vei`.`km_pastilha`) AS `km_pastilha_percorrido`,
	((`vei`.`km_atual` - `vei`.`km_pneu`) > `skm_pneu`.`value`) AS `manutencao_pneu`,
	(`vei`.`km_atual` - `vei`.`km_pneu`) AS `km_pneu_percorrido`,
	((`vei`.`km_atual` - `vei`.`km_filtro_ar`) > `skm_pneu`.`value`) AS `manutencao_filtro_ar`,
	(`vei`.`km_atual` - `vei`.`km_filtro_ar`) AS `km_filtro_ar_percorrido`,
	((`vei`.`km_atual` - `vei`.`km_filtro_comb`) > `skm_pneu`.`value`) AS `manutencao_filtro_comb`,
	(`vei`.`km_atual` - `vei`.`km_filtro_comb`) AS `km_filtro_comb_percorrido`,
	((`vei`.`km_atual` - `vei`.`km_disco`) > `skm_pneu`.`value`) AS `manutencao_disco`,
	(`vei`.`km_atual` - `vei`.`km_disco`) AS `km_disco_percorrido`,
	((`vei`.`km_atual` - `vei`.`km_correia`) > `skm_pneu`.`value`) AS `manutencao_correia`,
	(`vei`.`km_atual` - `vei`.`km_correia`) AS `km_correia_percorrido`
FROM `softsat_locacao_veiculo_detalhe` `vei`
LEFT JOIN `softsat_locacao_grupo` `gru` ON `gru`.`id` = `vei`.`grupo_id`
LEFT JOIN `softsat_locacao_marca` `mar` ON `mar`.`id` = `vei`.`marca_id`
LEFT JOIN `hwapx_setting` `skm_oleo` ON `skm_oleo`.`id` = 'softsat.locacao.manutencao.km_oleo'
LEFT JOIN `hwapx_setting` `sdias_oleo` ON `sdias_oleo`.`id` = 'softsat.locacao.manutencao.dias_oleo'
LEFT JOIN `hwapx_setting` `skm_past` ON `skm_past`.`id` = 'softsat.locacao.manutencao.km_pastilha'
LEFT JOIN `hwapx_setting` `skm_pneu` ON `skm_pneu`.`id` = 'softsat.locacao.manutencao.km_pneu'
LEFT JOIN `hwapx_setting` `skm_far` ON `skm_far`.`id` = 'softsat.locacao.manutencao.km_filtro_ar'
LEFT JOIN `hwapx_setting` `skm_fcomb` ON `skm_fcomb`.`id` = 'softsat.locacao.manutencao.km_filtro_comb'
LEFT JOIN `hwapx_setting` `skm_disco` ON `skm_disco`.`id` = 'softsat.locacao.manutencao.km_disco'
LEFT JOIN `hwapx_setting` `skm_correia` ON `skm_correia`.`id` = 'softsat.locacao.manutencao.km_correia'
WHERE `vei`.`ativo` = 1