DROP VIEW IF EXISTS softsat_locacao_local_horario_resumo;

CREATE VIEW softsat_locacao_local_horario_resumo AS
    SELECT
        lhor.local_id,
        GROUP_CONCAT(dia_semana SEPARATOR ', ') AS dias_semana,
        abertura,
        fechamento
    FROM softsat_locacao_local_horario AS lhor
    GROUP BY
        lhor.local_id,
        lhor.abertura,
        lhor.fechamento
    ORDER BY
        dia_semana ASC;
        
select * from softsat_locacao_local_horario_resumo;
        
/*
SELECT
    lhor.local_id,
    GROUP_CONCAT(dia_semana) AS dias_semana,
    IF(LENGTH(GROUP_CONCAT(dia_semana)) <= 7, 
        GROUP_CONCAT(dia_semana ORDER BY dia_semana),
        CONCAT(
            SUBSTRING(GROUP_CONCAT(dia_semana), 1, 3), 
            '-', 
            SUBSTRING(GROUP_CONCAT(dia_semana), -3, 3)
        )
    ) AS dias_intervalo,
    abertura,
    fechamento
FROM (
    SELECT 
        hh.*,
        @_change := IF(hh.hash = @_last, @_change, @_change + 1) AS change_count,
        @_last := IF(hh.hash = @_last, @_last, hh.hash)
    FROM (
        SELECT
            local_id,
            dia_Semana,
            abertura,
            fechamento,
            CONCAT(local_id, IFNULL(abertura, 'A'), IFNULL(fechamento, 'F')) as hash
        FROM softsat_locacao_local_horario
    ) AS hh
    CROSS JOIN (SELECT @_change := 0, @_last) AS var
) AS lhor
GROUP BY
    lhor.change_count,
    lhor.local_id,
    lhor.abertura,
    lhor.fechamento
ORDER BY
    dia_semana ASC*/