<style>
@page {
    margin: 5mm;
}


* {
    font-family: 'Helvetica' !important;
}

td, th {
    border: 0;
    padding: 0;
}

hr {
    background-color: black;
    height: 0.1mm;
}

table {
    width: 100%;
    table-layout: fixed;
    font-size: 12px !important;
}

p {
    text-align: justify;
}

header {
    margin: 0 0 5mm 0;
    background-color: #D6DCE5;
    color: #7F7F7F;
    padding: 2mm 5mm 2mm 5mm;
    font-size: 16px;
    position: relative;
    text-align: right;
}

header img {
    position: absolute;
    top: 3mm;
    left: 5mm;
}

footer {
    position: fixed;
    bottom: 5mm;
    left: 0;
    right: 0;
}

.status {
    font-size: 12px;
}
</style>
<div id="print">
    <header style="background-color: #D6DCE5;">
        <img src="assets/img/logo_rel.png" alt="Logo" style="width: 24%;">
        <div style="float: right;">
            Contrato de Aluguel de Veículos / Proposta de Seguro Nº <?= ($contrato['id']) ?><br>
            <small class="status"><?= (array('R' => 'Reserva', 'A' => 'Aberto', 'F' => 'Faturado', 'C' => 'Cancelado')[$contrato['status']]) ?></small>
        </div>
        <div style="clear:both"></div>
    </header>
    <!--
    <td colspan="2"><?= (array('R' => 'Reserva', 'A' => 'Aberto', 'F' => 'Faturado', 'C' => 'Cancelado')[$contrato['status']]) ?></td>

Av. Joaquim Moreira da Silva, 1839 - São José - José Bonifácio - SP
CEP: 15200-000
Telefone: 17 3245-2127
-->
    <table>
        <tr>
            <th colspan="4">Cliente</th>
            <th colspan="4">Local de Retirada</th>
            <th colspan="4">Local de Entrega</th>
        </tr>
        <tr>
            <td colspan="4" style="vertical-align: top;"><?= ($contrato['cliente_cnpj_cpf']) ?><br><?= ($contrato['cliente']) ?></td>
            <td colspan="4" style="font-size: 12px;">
                <?= ($contrato['local_saida']) ?><br>
                <?= ($contrato['local_saida_razao']) ?><br>
                <?= ($contrato['local_saida_endereco']) ?>, <?= ($contrato['local_saida_numero']) ?><br>
                <?= ($contrato['local_saida_bairro']) ?><br>
                <?= ($contrato['local_saida_cep']) ?> - <?= ($contrato['local_saida_cidade']) ?> - <?= ($contrato['local_saida_estado']) ?><br>
                CNPJ: <?= ($contrato['local_saida_cnpj']) ?><br>
                Telefone: <?= ($contrato['local_saida_telefone']) ?><br>
                <strong>Horário de funcionamento</strong><br>
                <?php foreach (($local_saida_horario?:[]) as $horario): ?>
                    <?= ($horario['dias_semana']) ?> <?= (substr($horario['abertura'], 0, 5) ?: 'e feriados fechado') ?> <?= ($horario['fechamento'] ? ' - ': '') ?> <?= (substr($horario['fechamento'], 0, 5) ?: '') ?><br>
                <?php endforeach; ?>
            </td>
            <td colspan="4" style="font-size: 12px;">
                <?= ($contrato['local_entrada']) ?><br>
                <?= ($contrato['local_entrada_razao']) ?><br>
                <?= ($contrato['local_entrada_endereco']) ?>, <?= ($contrato['local_entrada_numero']) ?><br>
                <?= ($contrato['local_entrada_bairro']) ?><br>
                <?= ($contrato['local_entrada_cep']) ?> - <?= ($contrato['local_entrada_cidade']) ?> - <?= ($contrato['local_entrada_estado']) ?><br>
                CNPJ: <?= ($contrato['local_entrada_cnpj']) ?><br>
                Telefone: <?= ($contrato['local_entrada_telefone']) ?><br>
                <strong>Horário de funcionamento</strong><br>
                <?php foreach (($local_entrada_horario?:[]) as $horario): ?>
                    <?= ($horario['dias_semana']) ?> <?= (substr($horario['abertura'], 0, 5) ?: 'e feriados fechado') ?> <?= ($horario['fechamento'] ? ' - ': '') ?> <?= (substr($horario['fechamento'], 0, 5) ?: '') ?><br>
                <?php endforeach; ?>
            </td>
        </tr>
        <tr>
            <td colspan="12"><hr></td>
        </tr>
        <tr>
            <th colspan="1">Veículo:</th>
            <td colspan="1"><?= ($contrato['veiculo_placa']) ?></td>
            <td colspan="2"><?= ($contrato['veiculo_marca']) ?> <?= ($contrato['veiculo_modelo']) ?></td>
            <td colspan="4"></td>
            <th colspan="4">Indenização por custos operacionais</th>
        </tr>
        <tr>
            <th colspan="1">Grupo: </th>
            <td colspan="3"><?= ($contrato['veiculo_grupo']) ?></td>
            <th colspan="2">Tanque: </th>
            <td colspan="2"><?= ($contrato['tanque_saida']) ?></td>
            <th colspan="2">Danos ao carro:</th>
            <td colspan="2" style="text-align: right;"><?= (number_format($contrato['indenizacao_carro'], 2, '.', ',')) ?></td>
        </tr>
        <tr>
            <th colspan="1">Saída: </th>
            <td colspan="3"><?= (\Base::instance()->call($this->filter('date'),[$contrato['saida'], 'd/m/Y H:i'])) ?></td>
            <th colspan="2">Entrada: </th>
            <td colspan="2"><?= (\Base::instance()->call($this->filter('date'),[$contrato['previsto'], 'd/m/Y H:i'])) ?></td>
            <th colspan="2">Danos a terceiros:</th>
            <td colspan="2" style="text-align: right;"><?= (number_format($contrato['indenizacao_terceiros'], 2, '.', ',')) ?></td>
        </tr>
        <tr>
            <th colspan="1">Km saída:</th>
            <td colspan="3"><?= (number_format($contrato['km_saida'], 0, ',', '.')) ?></td>
            <th colspan="2">Km contratado:</th>
            <td colspan="2"><?= ($contrato['km_contratado'] > 0 ? number_format($contrato['km_contratado'], 0, ',', '.') : 'Livre') ?></td>
            <?php if ($contrato['km_contratado'] > 0): ?>
                <th colspan="2">Valor por km excedente:</th>
                <td colspan="2" style="text-align: right;"><?= (number_format($contrato['valor_km_excedido'], 2, ',', '.')) ?></td>
            <?php endif; ?>
        </tr>
        <tr>
            <td colspan="12"><hr></td>
        </tr>
        <tr>
            <th colspan="1">Tarifa: </th>
            <td colspan="3"><?= ($contrato['tarifa']) ?></td>
            <td colspan="1"><?= (number_format($contrato['diaria'], 2, ',', '.')) ?></td>
            <th colspan="2">x dias: </th>
            <td colspan="2"><?= (number_format($contrato['dias_previstos'], 3, ',', '.')) ?></td>
            <th colspan="1">= Total: </th>
            <td colspan="2"><?= ($contrato['total_previsto'] ? number_format($contrato['total_previsto'], 2, ',', '.') : '') ?></td>
        </tr>
        <tr>
            <td colspan="12"><hr></td>
        </tr>
        <tr>
            <th colspan="12">Informações do seguro</th>
        </tr>
        <tr>
            <th colspan="3">Coberturas</th>
            <th colspan="4">Límite Máximo de indenização (R$)</th>
        </tr>
        <tr>
            <td colspan="3">RCF - Danos Materiais</td>
            <td colspan="4">R$ 80.000,00</td>
        </tr>
        <tr>
            <td colspan="3">RCF - Danos Corporais</td>
            <td colspan="4">R$ 80.000,00</td>
        </tr>
        <tr>
            <td colspan="3">RCF - Danos Morais</td>
            <td colspan="4">R$ 5.000,00</td>
        </tr>
        <tr>
            <td colspan="12">
                <p>Por este instrumento particular, as partes acima qualificadas celebram contrato de locação de veículo nas condições abaixo ajustadas:</p>
                <p><strong>Cláusula 1ª.:</strong>
                O CLIENTE declara que recebe o carro alugado em perfeitas condições de conservação e funcionamento.</p>
                <p><strong>Cláusula 2ª.:</strong>
                O cliente declara que anuiu às Condições Gerais do Contrato de Aluguel de Carros e Seguro, registradas sob o número 17937 junto ao cartório de títulos e documentos de José Bonifácio/SP, tendo recebido cópia integral do documento.
                <p><strong>Cláusula 3ª.:</strong>
                O CLIENTE assume a responsabilidade por todas as infrações cometidas na condução do carro alugado, bem como assume a pontuação decorrente destas, nos termos do artigo 5° e seus parágrafos, da Resolução 619/16 do CONTRAN, e constitui a LOCADORA como sua procuradora para assinar o termo de apresentação do condutor/infrator das multas de trânsito que envolva o carro alugado durante a vigência deste Contrato, incluindo todos os períodos de prorrogação, até a devolução efetiva do veículo, nos termos do art. 257, parágrafos 1º, 3º, 7º e 8º do Código Brasileiro de Trânsito, e da cláusula 6.4 das Condições Gerais do Contrato de Aluguel de Carros e Seguro.</p>
                <p><strong>Cláusula 4ª.:</strong>
                Caso o CLIENTE tenha aderido a contratação do seguro, de acordo com as coberturas, condições e prêmios previstos na proposta de seguro, o seguro atenderá, ainda, as seguintes condições:<br>
                1. A aceitação do seguro estará sujeita à análise do risco;<br>
                2. O registro deste plano na SUSEP não implica, por parte da Autarquia, incentivo ou recomendação a sua comercialização;<br>
                3. O CLIENTE poderá consultar a situação cadastral de seu corretor de seguros, no site www.susep.gov.br, por meio do número de seu registro na SUSEP, nome completo, CNPJ ou CPF;<br>
                4. O CLIENTE declara que todas as informações prestadas nesta proposta de seguro são verdadeiras e completas. O CLIENTE declara que tem conhecimento de que as perguntas formuladas neste documento são determinantes para aceitação e precificação do risco e assume total responsabilidade por elas, pois está ciente de que inexatidões ou omissões acarretam a perda de cobertura nos termos do art.<br>
                766 do Código Civil. O CLIENTE compromete-se a comunicar por escrito à Seguradora qualquer alteração que ocorra nas condições estabelecidas no contrato de seguro no decorrer da vigência da apólice.<br>
                5. O CLIENTE declara ainda ter recebido uma via e ter tomado conhecimento prévio das Condições Gerais que regem o contrato de seguro de automóvel a elas anuindo em integralidade. </p>
            </td>
        </tr>
        <tr>
            <td colspan="12"><hr></td>
        </tr>
        <tr>
            <td colspan="3"></td>
            <td colspan="6" style="text-align: center">
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <hr>
                Assinatura do Cliente
            </td>
            <td colspan="3"></td>
        </tr>
    </table>
    <footer>
        <table>
            <tr>
                <td>
                    <?= (array('Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sabado')[date('w', strtotime($contrato['saida']))]) ?>,
                    <?= (date('d', strtotime($contrato['saida']))) ?> de
                    <?= (array('Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro')[date('n', strtotime($contrato['saida'])) - 1]) ?> de
                    <?= (date('Y', strtotime($contrato['saida'])))."
" ?>
                </td>
            </tr>
        </table>
    </footer>
</div>