<style>
    @page {
        margin: 5mm;
    }
    
    * {
        font-family: 'Helvetica' !important;
    }
    
    td, th {
        border: 0;
        padding: 0;
    }
    
    hr {
        background-color: black;
        height: 0.1mm;
    }
    
    table {
        width: 100%;
        table-layout: fixed;
        font-size: 12px !important;
    }
    
    p {
        text-align: justify;
    }
    
    header {
        margin: 0 0 5mm 0;
        background-color: #D6DCE5;
        color: #7F7F7F;
        padding: 2mm 5mm 2mm 5mm;
        font-size: 16px;
        position: relative;
        text-align: right;
    }
    
    header img {
        position: absolute;
        top: 3mm;
        left: 5mm;
    }
    
    footer {
        position: fixed;
        bottom: 5mm;
        left: 0;
        right: 0;
    }
    
    .status {
        font-size: 12px;
    }
    
    .border {
        border: 2px solid black;
        border-collapse: collapse;
    }
    
    tr.border>td, tr.border>th {
        border-top: 2px solid black;
        border-bottom: 2px solid black;
    }
    
    .text-center {
        text-align: center;
    }
    
    .text-right {
        text-align: right;
    }
    
    .text-positive {
        color: #00a65a;
    }
    
    .text-negative {
        color: #f56954;
    }
    </style>
    <div id="print">
        <div>
            <header style="background-color: #D6DCE5;">
                <img src="assets/img/logo_rel.png" alt="Logo" style="width: 24%;">
                <div style="float: right;">
                    Relatório de faturamento detalhado<br>
                    <small class="status">Período: <?= ($filtro['data_de']) ?> a <?= ($filtro['data_ate']) ?></small>
                </div>
                <div style="clear:both"></div>
            </header>
    
            <table>
                <tr>
                    <th colspan="1">Marca:</th>
                    <td colspan="5"><?= ($filtro['marca'] ? $filtro['marca']['nome'] : 'Todas') ?></td>
                    <th colspan="1">Grupo:</th>
                    <td colspan="5"><?= ($filtro['grupo'] ? $filtro['grupo']['nome'] : 'Todos') ?></td>
                </tr>
                <tr>
                    <td colspan="12"><hr></td>
                </tr>
                <tr>
                    <th colspan="1">Placa</th>
                    <th colspan="2">Modelo</th>
                    <th colspan="1">Marca</th>
                    <th colspan="3">Grupo</th>
                    <th colspan="1" class="text-right">Receita</th>
                    <th colspan="1" class="text-right">Despesa</th>
                    <th colspan="1" class="text-right">Saldo</th>
                    <th colspan="1" class="text-right">D. Rateio</th>
                    <th colspan="1" class="text-right">S. Rateio</th>
                </tr>
                <?php $tr = $td = 0 ?>
                <?php foreach (($veiculos?:[]) as $veiculo): ?>
                    <tr>
                        <td colspan="1"><?= ($veiculo['placa']) ?></td>
                        <td colspan="2"><?= ($veiculo['modelo']) ?></td>
                        <td colspan="1"><?= ($veiculo['marca']) ?></td>
                        <td colspan="3"><?= ($veiculo['grupo']) ?></td>
                        <?php $r = array_aggregate($contratos[$veiculo['id']], 'total') ?>
                        <td colspan="1" class="text-right"><?= (number_format($r, 2, ',', '.')) ?></td>
                        <?php $d = array_aggregate($despesas[$veiculo['id']], 'valor') ?>
                        <td colspan="1" class="text-right"><?= (number_format($d, 2, ',', '.')) ?></td>
                        <td colspan="1" class="text-right text-<?= ($r > $d ? 'positive' : 'negative') ?>"><?= (number_format($r - $d, 2, ',', '.')) ?></td>
                        <?php $g = array_aggregate($despesas_gerais, 'valor') / $qtde_veiculos ?>
                        <td colspan="1" class="text-right"><?= (number_format($g, 2, ',', '.')) ?></td>
                        <td colspan="1" class="text-right text-<?= ($r > $d + $g ? 'positive' : 'negative') ?>"><?= (number_format($r - $g - $d, 2, ',', '.')) ?></td>
                        <?php $tr += $r; $tg += $g; $td += $d ?>
                    </tr>
                    <?php foreach (($contratos[$veiculo['id']]?:[]) as $contrato): ?>
                        <tr style="color: #B4B4B4">
                            <td colspan="1" class="text-center">C-<?= ($contrato['id']) ?></td>
                            <td colspan="5">[<?= ($contrato['cliente_cnpj_cpf']) ?>] <?= ($contrato['cliente']) ?></td>
                            <td colspan="1"><?= (\Base::instance()->call($this->filter('date'),[$contrato['entrada'],'d/m/Y'])) ?></td>
                            <td colspan="1" class="text-right"><?= (number_format($contrato['total'], 2, ',', '.')) ?></td>
                            <td colspan="1" class="text-right"></td>
                            <td colspan="1" class="text-right"><?= (number_format($contrato['total'], 2, ',', '.')) ?></td>
                            <td colspan="1" class="text-right"></td>
                            <td colspan="1" class="text-right"><?= (number_format($contrato['total'], 2, ',', '.')) ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php foreach (($despesas[$veiculo['id']]?:[]) as $despesa): ?>
                        <tr style="color: #B4B4B4">
                            <td colspan="1" class="text-center">D-<?= ($despesa['id']) ?></td>
                            <td colspan="5"><?= ($despesa['plano_conta']) ?></td>
                            <td colspan="1"><?= (\Base::instance()->call($this->filter('date'),[$despesa['data'],'d/m/Y'])) ?></td>
                            <td colspan="1" class="text-right"></td>
                            <td colspan="1" class="text-right"><?= (number_format($despesa['valor'], 2, ',', '.')) ?></td>
                            <td colspan="1" class="text-right"><?= (number_format($despesa['valor'], 2, ',', '.')) ?></td>
                            <td colspan="1" class="text-right"></td>
                            <td colspan="1" class="text-right"><?= (number_format($despesa['valor'], 2, ',', '.')) ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php foreach (($despesas_gerais?:[]) as $despesa): ?>
                        <tr style="color: #B4B4B4">
                            <td colspan="1" class="text-center">D-<?= ($despesa['id']) ?></td>
                            <td colspan="5"><?= ($despesa['plano_conta']) ?></td>
                            <td colspan="1"><?= (\Base::instance()->call($this->filter('date'),[$despesa['data'],'d/m/Y'])) ?></td>
                            <td colspan="1" class="text-right"></td>
                            <td colspan="1" class="text-right"></td>
                            <td colspan="1" class="text-right"></td>
                            <td colspan="1" class="text-right"><?= (number_format($despesa['valor'] / $qtde_veiculos, 2, ',', '.')) ?></td>
                            <td colspan="1" class="text-right"><?= (number_format($despesa['valor'] / $qtde_veiculos, 2, ',', '.')) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endforeach; ?>
                <tr>
                    <td colspan="12"><hr></td>
                </tr>
                <tr>
                    <th colspan="7" class="text-right">Total</th>
                    <th colspan="1" class="text-right <?= ($tr > 0 ? 'text-positive' : '') ?>"><?= (number_format($tr, 2, ',', '.')) ?></th>
                    <th colspan="1" class="text-right text-negative"><?= (number_format($td, 2, ',', '.')) ?></th>
                    <th colspan="1" class="text-right text-<?= ($tr > $td ? 'positive' : 'negative') ?>"><?= (number_format($tr - $td, 2, ',', '.')) ?></th>
                    <th colspan="1" class="text-right text-negative"><?= (number_format($tg, 2, ',', '.')) ?></th>
                    <th colspan="1" class="text-right text-<?= ($tr > $td + $tg ? 'positive' : 'negative') ?>"><?= (number_format($tr - $tg - $td, 2, ',', '.')) ?></th>
                </tr>
            </table>
        </div>
    </div>