<style>
@page {
    margin: 5mm;
}

* {
    font-family: 'Helvetica' !important;
}

td, th {
    border: 0;
    padding: 0;
}

hr {
    background-color: black;
    height: 0.1mm;
}

table {
    width: 100%;
    table-layout: fixed;
    font-size: 12px !important;
}

p {
    text-align: justify;
}

header {
    margin: 0 0 5mm 0;
    background-color: #D6DCE5;
    color: #7F7F7F;
    padding: 2mm 5mm 2mm 5mm;
    font-size: 16px;
    position: relative;
    text-align: right;
}

header img {
    position: absolute;
    top: 3mm;
    left: 5mm;
}

footer {
    position: fixed;
    bottom: 5mm;
    left: 0;
    right: 0;
}

.status {
    font-size: 12px;
}

.fatura td, .fatura th {
    padding: 4px;
}

.border {
    border: 2px solid black;
    border-collapse: collapse;
}

tr.border>td, tr.border>th {
    border-top: 2px solid black;
    border-bottom: 2px solid black;
}

.text-center {
    text-align: center;
}

.text-right {
    text-align: right;
}
</style>
<div id="print">
    <div>
        <header style="background-color: #D6DCE5;">
            <img src="assets/img/logo_rel.png" alt="Logo" style="width: 24%;">
            <div style="float: right;">
                Contrato de Aluguel de Veículos / Proposta de Seguro Nº <?= ($contrato['id']) ?><br>
                <small class="status"><?= (array('R' => 'Reserva', 'A' => 'Aberto', 'F' => 'Faturado', 'C' => 'Cancelado')[$contrato['status']]) ?></small>
            </div>
            <div style="clear:both"></div>
        </header>

        <table>
            <tr>
                <th colspan="1">Cliente:</th>
                <td colspan="11"><?= ($contrato['cliente_cnpj_cpf']) ?> <?= ($contrato['cliente']) ?></td>
            </tr>
            <tr>
                <td colspan="12"><hr></td>
            </tr>
            <tr>
                <th colspan="1">Veículo:</th>
                <td colspan="7"><?= ($contrato['veiculo_placa']) ?> <?= ($contrato['veiculo_marca']) ?> <?= ($contrato['veiculo_modelo']) ?></td>
                <th colspan="4">Indenização por custos operacionais:</th>
            </tr>
            <tr>
                <th colspan="1">Grupo:</th>
                <td colspan="7"><?= ($contrato['veiculo_grupo']) ?></td>
                <th colspan="2">Danos ao carro:</th>
                <td colspan="2"><?= (number_format($contrato['indenizacao_carro'], 2, ',', '.')) ?></td>
            </tr>
            <tr>
                <td colspan="8"></td>
                <th colspan="2">Danos a terceiros:</th>
                <td colspan="2"><?= (number_format($contrato['indenizacao_terceiros'], 2, ',', '.')) ?></td>
            </tr>
            <tr>
                <th colspan="1">Saída:</th>
                <td colspan="2"><?= (\Base::instance()->call($this->filter('date'),[$contrato['saida'],'d/m/Y H:i'])) ?></td>
                <th colspan="1">Local:</th>
                <td colspan="4"><?= ($contrato['local_entrada']) ?></td>
                <th colspan="1">Km:</th>
                <td colspan="1"><?= (number_format($contrato['km_saida'], 0, ',', '.')) ?></td>
                <th colspan="1">Tanque:</th>
                <td colspan="1"><?= ($contrato['tanque_saida']) ?></td>
            </tr>
            <tr>
                <th colspan="1">Entrada:</th>
                <td colspan="2"><?= (\Base::instance()->call($this->filter('date'),[$contrato['entrada'],'d/m/Y H:i'])) ?></td>
                <th colspan="1">Local:</th>
                <td colspan="4"><?= ($contrato['local_entrada']) ?></td>
                <th colspan="1">Km:</th>
                <td colspan="1"><?= (number_format($contrato['km_entrada'], 0, ',', '.')) ?></td>
                <th colspan="1">Tanque:</th>
                <td colspan="1"><?= ($contrato['tanque_entrada']) ?></td>
            </tr>
            <tr>
                <th colspan="1">Utilização:</th>
                <td colspan="7">
                    <?= ((int)$contrato['dias_cobrados']) ?> diária(s)
                    <?php $horas = ($contrato['dias_cobrados'] - (int)$contrato['dias_cobrados']) * 24 ?>
                    <?= ((int)$horas) ?> horas(s)
                    <?php $minutos = ceil(($horas - (int)$horas) * 60) ?>
                    e <?= ($minutos) ?> minutos(s)
                </td>
                <th colspan="1">Km:</th>
                <td colspan="1"><?= (number_format($contrato['km_utilizado'], 0, ',', '.')) ?></td>
            </tr>
            <tr>
                <td colspan="12"><hr></td>
            </tr>
            <tr>
                <th colspan="2">Tarifa:</th>
                <td colspan="6"><?= ($contrato['tarifa']) ?></td>
                <th colspan="2">Km contratado:</th>
                <td colspan="2"><?= ($contrato['km_contratado'] > 0 ? number_format($contrato['km_contratado'], 0, ',', '.') : 'Livre') ?></td>
            </tr>
            <tr>
                <th colspan="3">Forma de pagamento:</th>
                <td colspan="9"><?= ($contrato['forma_pagamento']) ?></td>
            </tr>
            <tr>
                <th colspan="6">Demonstrativo de valores</th>
                <th colspan="2" style="text-align: right">Unitário</th>
                <th colspan="2" style="text-align: right">Quantidade</th>
                <th colspan="2" style="text-align: right">Total</th>
            </tr>
            <tr>
                <td colspan="6">Diária</td>
                <td colspan="2" style="text-align: right"><?= (number_format($contrato['diaria'], 2, ',', '.')) ?></td>
                <td colspan="2" style="text-align: right"><?= (number_format($contrato['dias_cobrados'], 3, ',', '.')) ?></td>
                <td colspan="2" style="text-align: right"><?= (number_format($contrato['diaria'] * $contrato['dias_cobrados'], 2, ',', '.')) ?></td>
            </tr>
            <?php if ($contrato['valor_multa_excedido'] > 0): ?>
                <tr>
                    <td colspan="6">Multa por exceder a data de entrada prevista</td>
                    <?php $multa_frac = ($contrato['perc_multa_excedido'] > 0 ? $contrato['perc_multa_excedido'] / 100.0 : 0) ?>
                    <td colspan="2" style="text-align: right"><?= (number_format($contrato['diaria'] * $multa_frac, 2, ',', '.')) ?></td>
                    <td colspan="2" style="text-align: right"><?= (number_format($contrato['dias_excedidos'], 3, ',', '.')) ?></td>
                    <td colspan="2" style="text-align: right"><?= (number_format($contrato['valor_multa_excedido'], 2, ',', '.')) ?></td>
                </tr>
            <?php endif; ?>
            <?php if ($contrato['total_km_excedido'] > 0): ?>
                <tr>
                    <td colspan="6">Multa por exceder a km contratada</td>
                    <td colspan="2" style="text-align: right"><?= (number_format($contrato['valor_km_excedido'], 2, ',', '.')) ?></td>
                    <td colspan="2" style="text-align: right"><?= (number_format($contrato['km_excedido'], 0, ',', '.')) ?></td>
                    <td colspan="2" style="text-align: right"><?= (number_format($contrato['total_km_excedido'], 2, ',', '.')) ?></td>
                </tr>
            <?php endif; ?>
            <tr>
                <th colspan="10">Acréscimo/Desconto</th>
                <th colspan="2" style="text-align: right"><?= (number_format($contrato['acrescimo_desconto'], 2, ',', '.')) ?></th>
            </tr>
            <tr>
                <th colspan="10">Total</th>
                <th colspan="2" style="text-align: right"><?= (number_format($contrato['total'], 2, ',', '.')) ?></th>
            </tr>
            <tr>
                <th colspan="12"><hr>Observações</th>
            </tr>
            <tr>
                <td colspan="12" style="height: 4em;"><p><?= (nl2br($contrato['observacao'])) ?></p></td>
            </tr>
            <tr>
                <th colspan="12"><hr></th>
            </tr>
            <tr>
                <td colspan="12">
                    <p>Por este instrumento particular, as partes acima qualificadas celebram contrato de locação de veículo nas condições abaixo ajustadas:</p>
                    <p>Cláusula 1ª.:<br>
                    O CLIENTE declara que devolveu o carro alugado na data acima e que conferiu e aprovou os valores da locação, sob pena de sua omissão implicar em anuência, na 
                    forma do art. 111 do Código Civil.</p>
                    <p>Cláusula 2ª.:<br>
                    O  cliente  declara  que  anuiu  às  Condições  Gerais  do  Contrato  de  Aluguel  de  Carros  e  Seguro,  registradas  sob  o  número  
                    17937 junto ao cartório de títulos e documentos de José Bonifácio/SP, tendo recebido cópia integral do documento.</p>
                </td>
            </tr>
        </table>
    </div>
    <div style="border-top: 1 dashed black; margin-top: 5px; height: 15px;"></div>
    <div style="clear: both"></div>
    <div class="fatura">
        <table class="border">
            <tr>
                <th colspan="2" class="border">
                    <img src="assets/img/logo_rel.png" alt="Logo" style="width: 100%;">
                </th>
                <th colspan="6" class="border"><?= ($contrato['local_entrada_razao']) ?><br>
                    <?= ($contrato['local_entrada']) ?><br>
                    <?= ($contrato['local_entrada_endereco']) ?>, <?= ($contrato['local_entrada_numero']) ?> - <?= ($contrato['local_entrada_bairro']) ?><br>
                    <?= ($contrato['local_entrada_cep']) ?> - <?= ($contrato['local_entrada_cidade']) ?> - <?= ($contrato['local_entrada_estado']) ?><br>
                    CNPJ: <?= ($contrato['local_entrada_cnpj'])."
" ?>
                </th>
                <th colspan="4" class="text-center border">
                    <?= ($contrato['local_entrada_telefone']) ?><br>
                    <?= ($contrato['local_entrada_email'])."
" ?>
                </th>
            </tr>
            <tr class="border">
                <th colspan="8" class="text-center">FATURA/DUPLICATA</th>
                <th colspan="4" class="text-center">Nº <?= ($contrato['id']) ?></th>
            </tr>
            <tr class="">
                <td colspan="2">CLIENTE:</td>
                <td colspan="6"><?= ($contrato['cliente']) ?></td>
                <td colspan="2">CÓDIGO:</td>
                <td colspan="2"><?= ($contrato['cliente_id']) ?></td>
            </tr>
            <tr>
                <td colspan="2">ENDEREÇO:</td>
                <td colspan="6"><?= ($contrato['cliente_endereco']) ?>, <?= ($contrato['cliente_numero']) ?> - <?= ($contrato['cliente_bairro']) ?></td>
                <td colspan="2">CNPJ/CPF:</td>
                <td colspan="2"><?= ($contrato['cliente_cnpj_cpf']) ?></td>
            </tr>
            <tr>
                <td colspan="2">CEP/CID/UF:</td>
                <td colspan="6"><?= ($contrato['cliente_cep']) ?>, <?= ($contrato['cliente_cidade']) ?> - <?= ($contrato['cliente_estado']) ?></td>
                <th colspan="2">EMISSÃO:</th>
                <th colspan="2"><?= (\Base::instance()->call($this->filter('date'),[$contrato['data_status'], 'd/m/Y'])) ?></th>
            </tr>
            <tr class="border text-center" style="background: silver">
                <th colspan="8">DESCRIÇÃO</th>
                <th colspan="4">VALOR</th>
            </tr>
            <tr style="vertical-align: top;">
                <td colspan="8" class="border" style="height: 5em">ALUGUEL CONFORME CONTRATO Nº <b><?= ($contrato['id']) ?></b></td>
                <td colspan="4" class="border text-right">R$ <?= (number_format($contrato['total'], 2, ',', '.')) ?></td>
            </tr>
            <tr class="text-center">
                <th colspan="4" class="border">PRIMEIRO VENCIMENTO</th>
                <th colspan="4" class="border">FORMA DE PAGAMENTO</th>
                <th colspan="4" class="border">VALOR TOTAL</th>
            </tr>
            <tr>
                <td colspan="4" class="border text-center"><?= (\Base::instance()->call($this->filter('date'),[$contrato['data_status'],'d/m/Y'])) ?></td>
                <td colspan="4" class="border text-center"><?= ($contrato['forma_pagamento']) ?> - <?= ($contrato['condicao_pagamento']) ?></td>
                <td colspan="4" class="border text-right">R$ <?= (number_format($contrato['total'], 2, ',', '.')) ?></td>
            </tr>
            <tr class="text-center">
                <td colspan="1"></td>
                <th colspan="4">
                    <br>
                    <br>
                    <br>
                    <br>
                    <br>
                    <hr>
                    Sacador
                </th>
                <td colspan="2"></td>
                <th colspan="4">
                    <br>
                    <br>
                    <br>
                    <br>
                    <br>
                    <hr>
                    Aceite
                </th>
                <td colspan="1"></td>
            </tr>
        </table>
    </div>
</div>