<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
    <h4 class="modal-title" id="registrar-label">Cadastre-se</h4>
</div>
<div class="modal-body">
    <?php if (isset($msg)): ?>
        <div class="alert alert-<?= ($erros ? 'danger' : 'success') ?>"><?= ($msg) ?></div>
    <?php endif; ?>
    <form class="dados-conta" id="registrar-form">
        <div class="row">
            <div class="col-md-8">
                <div class="form-group <?= ($erros['nome'] ? 'has-error' : '') ?>">
                    <label>Nome <span class="text-danger">*</span></label>
                    <input class="form-control" value="<?= ($cliente['nome']) ?>" name="nome" type="text" required>
                    <?php if ($erros['nome']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['nome'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4" style="min-height: 84px">
                <div class="form-group <?= ($erros['nascimento'] ? 'has-error' : '') ?>">
                    <label>Data de nascimento <span class="text-danger">*</span></label>
                    <div class="input-group" id="registrar-nascimento">
                        <input class="form-control" value="<?= (\Base::instance()->call($this->filter('date'),[strtotime($cliente['nascimento'])])) ?>" name="nascimento" data-date-format="DD/MM/YYYY" type="text" required>
                        <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>
                    </div>
                    <?php if ($erros['nascimento']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['nascimento'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group <?= ($erros['cnpj_cpf'] ? 'has-error' : '') ?>">
                    <label>CNPJ/CPF <span class="text-danger">*</span></label>
                    <input class="form-control" value="<?= ($cliente['cnpj_cpf']) ?>" data-inputmask-clearincomplete="true" data-inputmask-skip-optional-part-character=" " data-inputmask="" data-inputmask-mask="(999.999.999-99)|(99.999.999/9999-99)" data-inputmask-keepstatic="true" name="cnpj_cpf" type="text" required>
                    <?php if ($erros['cnpj_cpf']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['cnpj_cpf'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group <?= ($erros['ie_rg'] ? 'has-error' : '') ?>">
                    <label>IE/RG <span class="text-danger">*</span></label>
                    <input class="form-control" value="<?= ($cliente['ie_rg']) ?>" name="ie_rg" type="text" required pattern="^[0-9]*$" title="Apenas números, sem pontuação.">
                    <?php if ($erros['ie_rg']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['ie_rg'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group <?= ($erros['cnh'] ? 'has-error' : '') ?>">
                    <label>CNH <span class="text-danger">*</span></label>
                    <input class="form-control" value="<?= ($cliente['cnh']) ?>" name="cnh" type="text" required>
                    <?php if ($erros['cnh']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['cnh'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-8">
                <div class="form-group <?= ($erros['endereco'] ? 'has-error' : '') ?>">
                    <label>Endereço <span class="text-danger">*</span></label>
                    <input class="form-control" value="<?= ($cliente['endereco']) ?>" name="endereco" type="text" required>
                    <?php if ($erros['endereco']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['endereco'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group <?= ($erros['numero'] ? 'has-error' : '') ?>">
                    <label>Número</label>
                    <input class="form-control" value="<?= ($cliente['numero']) ?>" name="numero" type="text">
                    <?php if ($erros['numero']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['numero'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group <?= ($erros['bairro'] ? 'has-error' : '') ?>">
                    <label>Bairro</label>
                    <input class="form-control" value="<?= ($cliente['bairro']) ?>" name="bairro" type="text">
                    <?php if ($erros['bairro']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['bairro'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-5">
                <div class="form-group <?= ($erros['cidade'] ? 'has-error' : '') ?>">
                    <label>Cidade</label>
                    <input class="form-control" value="<?= ($cliente['cidade']) ?>" name="cidade" type="text">
                    <?php if ($erros['cidade']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['cidade'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group <?= ($erros['estado'] ? 'has-error' : '') ?>">
                    <label>Estado</label>
                    <select class="form-control" name="estado">
                        <option value="">-- Selecione --</option>
                        <?php $estados = array(
                            'AC' => 'Acre',
                            'AL' => 'Alagoas',
                            'AP' => 'Amapá',
                            'AM' => 'Amazonas',
                            'BA' => 'Bahia',
                            'CE' => 'Ceará',
                            'DF' => 'Distrito Federal',
                            'ES' => 'Espírito Santo',
                            'GO' => 'Goiás',
                            'MA' => 'Maranhão',
                            'MT' => 'Mato Grosso',
                            'MS' => 'Mato Grosso do Sul',
                            'MG' => 'Minas Gerais',
                            'PA' => 'Pará',
                            'PB' => 'Paraíba',
                            'PR' => 'Paraná',
                            'PE' => 'Pernambuco',
                            'PI' => 'Piauí',
                            'RJ' => 'Rio de Janeiro',
                            'RN' => 'Rio Grande do Norte',
                            'RS' => 'Rio Grande do Sul',
                            'RO' => 'Rondônia',
                            'RR' => 'Roraima',
                            'SC' => 'Santa Catarina',
                            'SP' => 'São Paulo',
                            'SE' => 'Sergipe',
                            'TO' => 'Tocantins',
                        ); ?>
                        <?php foreach (($estados?:[]) as $uf=>$estado): ?>
                            <option value="<?= ($uf) ?>" <?= ($cliente['estado'] == $uf ? 'selected' : '') ?>><?= ($estado) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <?php if ($erros['estado']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['estado'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group <?= ($erros['cep'] ? 'has-error' : '') ?>">
                    <label>CEP</label>
                    <input class="form-control" value="<?= ($cliente['cep']) ?>" data-inputmask-clearincomplete="true" data-inputmask-skip-optional-part-character=" " data-inputmask="" data-inputmask-mask="99999-999" name="cep" type="text">
                    <?php if ($erros['cep']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['cep'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group <?= ($erros['celular'] ? 'has-error' : '') ?>">
                    <label>Celular <span class="text-danger">*</span></label>
                    <input class="form-control" value="<?= ($cliente['celular']) ?>" data-inputmask-clearincomplete="true" data-inputmask-skip-optional-part-character=" " data-inputmask="" data-inputmask-mask="(99)99999-9999" name="celular" type="text" required>
                    <?php if ($erros['celular']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['celular'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group <?= ($erros['telefone'] ? 'has-error' : '') ?>">
                    <label>Telefone residencial</label>
                    <input class="form-control" value="<?= ($cliente['telefone']) ?>" data-inputmask-clearincomplete="true" data-inputmask-skip-optional-part-character=" " data-inputmask="" data-inputmask-mask="(99)9999-9999[9]" name="telefone" type="text">
                    <?php if ($erros['telefone']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['telefone'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group <?= ($erros['telefone_comercial'] ? 'has-error' : '') ?>">
                    <label>Telefone comercial</label>
                    <input class="form-control" value="<?= ($cliente['telefone_comercial']) ?>" data-inputmask-clearincomplete="true" data-inputmask-skip-optional-part-character=" " data-inputmask="" data-inputmask-mask="(99)9999-9999[9]" name="telefone_comercial" type="text">
                    <?php if ($erros['telefone_comercial']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['telefone_comercial'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group <?= ($erros['email'] ? 'has-error' : '') ?>">
                    <label>Email <span class="text-danger">*</span></label>
                    <input class="form-control" value="<?= ($cliente['email']) ?>" name="email" type="email" required>
                    <?php if ($erros['email']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['email'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group <?= ($erros['senha'] ? 'has-error' : '') ?>">
                    <label>Senha <span class="text-danger">*</span></label>
                    <input class="form-control" name="senha" value="" type="password" required>
                    <?php if ($erros['senha']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['senha'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group <?= ($erros['senha_confirmacao'] ? 'has-error' : '') ?>">
                    <label>Confirme a senha <span class="text-danger">*</span></label>
                    <input class="form-control" name="senha_confirmacao" value="" type="password" required>
                    <?php if ($erros['senha_confirmacao']): ?>
                        <p class="help-block text-danger"><?= (implode(', ', $erros['senha_confirmacao'])) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal-footer">
    <button type="submit" class="btn btn-success" form="registrar-form" id="registrar-btn">Cadastrar</button>
</div>

<script src="assets/js/jquery.inputmask.bundle.min.js" type="text/javascript"></script>
<script src="assets/js/inputmask/inputmask.binding.js" type="text/javascript"></script>

<script>
$('#registrar-form').submit(function(evt) {
    evt.preventDefault();
    
    var $frm = $(this);
    var $btn = $('#registrar-btn');
    
    $btn.prop('disabled', true);
    
    $.post('<?= (Base::instance()->alias("softsat_locacao_registrar")) ?>', $frm.serialize(), function(resp) {
        $('#registrar .modal-content').html(resp);
    }).fail(function() {
        alert('Falha na requisição, contate o administrador');
    }).always(function() {
        $btn.prop('disabled', false);
    });
    
    return false;
});
$(document).ready(function() {
   $('#registrar-nascimento').datetimepicker(); 
});
</script>
