<?php $page['title'] = 'Relatório';
    if(!isset($page['description']))
        $page['description'] = 'Relatório';

    $breadcrumbs = array('' => 'Locação', $page['title']);

    $meta['styles']['local']['select2']       = 'select2.min.css';
    $meta['styles']['local']['select2_bs']    = 'select2-bootstrap.min.css';
    $meta['scripts']['local']['select2']      = 'select2/select2.min.js';
    $meta['scripts']['local']['select2_i18n'] = 'select2/i18n/pt-BR.js';

    $meta['scripts']['local']['moment']       = 'moment.js';

    $meta['scripts']['local']['datetimepicker'] = 'bootstrap-datetimepicker.min.js';
    $meta['styles']['local']['datetimepicker']  = 'bootstrap-datetimepicker.min.css';
    array_unshift($meta['scripts']['raw'], '
        $(".date").datetimepicker();
        $(".select2").css("width", "100%").select2({theme: "bootstrap", minimumResultsForSearch: 5});
    '); ?>

<?php echo $this->render('hwapx/admin/admin/header.html',NULL,get_defined_vars(),0); ?>

<div class="row">
    <div class="col-lg-10 col-lg-offset-1 col-md-12">
        <!-- Custom tabs (Charts with tabs)-->
        <div class="nav-tabs-custom">
            <!-- Tabs within a box -->
            <ul class="dont-print nav nav-tabs pull-right">
                <li class="active"><a href="#relatorio_sintetico" data-toggle="tab">Faturamento</a></li>
                <li class="pull-left header">
                    <i class="glyphicon glyphicon-search"></i> Filtro
                </li>
            </ul>
            <!-- form start -->
            <form id="main_form" role="form" method="post" target="_blank" action="<?= (Base::instance()->alias('softsat_locacao_relatorio_pdf')) ?>">
                <div class="box" style="border:none">
                    <div class="box-body">
                        <div class="tab-content no-padding">
                            <div id="group_main" class="tab-pane active">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Detalhamento</label>
                                            <select class="form-control select2" name="detalhe" style="width: 100%;">
                                                <option value="resumo">Resumo</option>
                                                <option value="detalhe">Detalhado</option>
                                                <option value="plano_veiculo">Plano de contas</option>
                                                <option value="veiculo_plano">Veículo e plano de contas</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Veículo</label>
                                            <select class="form-control select2" name="veiculo_id" style="width: 100%;">
                                                <option value="">-- Todos --</option>
                                                <?php foreach (($veiculos?:[]) as $veiculo): ?>
                                                    <option value="<?= ($veiculo['id']) ?>">[<?= ($veiculo['placa']) ?>] <?= ($veiculo['marca']) ?> <?= ($veiculo['modelo']) ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Marca</label>
                                            <select class="form-control select2" name="marca_id" style="width: 100%;">
                                                <option value="">-- Todas --</option>
                                                <?php foreach (($marcas?:[]) as $marca): ?>
                                                    <option value="<?= ($marca['id']) ?>"><?= ($marca['nome']) ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Grupo</label>
                                            <select class="form-control select2" name="grupo_id" style="width: 100%;">
                                                <option value="">-- Todos --</option>
                                                <?php foreach (($grupos?:[]) as $grupo): ?>
                                                    <option value="<?= ($grupo['id']) ?>"><?= ($grupo['nome']) ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Período de
                                                <span class="text-danger">*</span>
                                            </label>
                                            <div class="input-group date">
                                                <input class="form-control" value="<?= (date('01/m/Y')) ?>" type="text" name="data_de" data-date-format="DD/MM/YYYY">
                                                <span class="input-group-addon">
                                                    <span class="glyphicon glyphicon-calendar"></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Período até
                                                <span class="text-danger">*</span>
                                            </label>
                                            <div class="input-group date">
                                                <input class="form-control" value="<?= (date('t/m/Y')) ?>" type="text" name="data_ate" data-date-format="DD/MM/YYYY">
                                                <span class="input-group-addon">
                                                    <span class="glyphicon glyphicon-calendar"></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div>
                            <input type="submit" class="btn btn-primary btn-flat" value="Visualizar">
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <!-- /.nav-tabs-custom -->
    </div>
</div>
<!-- /.row -->

<?php echo $this->render('hwapx/admin/admin/footer.html',NULL,get_defined_vars(),0); ?>