<!DOCTYPE html>
<html lang="pt-br">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="Content-Language" content="pt-br">
        <title><?= ($app['title']) ?><?= (isset($page['title']) ? ' :: '.$page['title'] : '') ?><?= (isset($page['description']) ? ' - ' . $page['description'] : '') ?></title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link href="<?= ($BASE) ?>/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- Ionicons -->
        
        <!-- Theme style -->
        <link href="<?= ($BASE) ?>/assets/css/AdminLTE.css" rel="stylesheet" type="text/css" />

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
          <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
          <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->
        <style>
        td[onclick]:hover {
            cursor: pointer;
        }
        </style>

        <?php foreach (($meta['styles']['raw']?:[]) as $content): ?>
            <style><?= (\Template::Instance()->resolve($content)) ?></style>
        <?php endforeach; ?>
    </head>
    <body class="skin-<?= (isset($settings['admin']['skin']) ? $settings['admin']['skin'] : 'blue') ?> <?= (isset($settings['admin']['layout']) ? $settings['admin']['layout'] : '') ?>">
        <!-- header logo: style can be found in header.less -->
        <header class="header">
            <a href="<?= ($BASE) ?><?= (Base::instance()->alias('admin_dashboard')) ?>" class="logo<?= ($settings['admin']['color'] ? ' bg-'.$settings['admin']['color'] : '') ?>">
                <!-- Add the class icon to your logo image or logo icon to add the margining -->
                <?= ($app['title'])."
" ?>
            </a>
            <!-- Header Navbar: style can be found in header.less -->
            <nav class="navbar navbar-static-top<?= ($settings['admin']['color'] ? ' bg-'.$settings['admin']['color'] : '') ?>" role="navigation">
                <!-- Sidebar toggle button-->
                <a href="#" class="navbar-btn sidebar-toggle" data-toggle="offcanvas" role="button">
                    <span class="sr-only">Alternar navegação</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </a>
                <div class="navbar-right">
                    <ul class="nav navbar-nav">
                        <?php if(\Base::instance()->exists('__place.navbar')) echo implode(PHP_EOL, \Base::instance()->get('__place.navbar')) ?>
                        
                        
                        <!-- User Account: style can be found in dropdown.less -->
                        <li class="dropdown user user-menu">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                <i class="glyphicon glyphicon-user"></i>
                                <span><?= ($admin['firstname']) ?> <i class="caret"></i></span>
                            </a>
                            <ul class="dropdown-menu">
                                <!-- User image -->
                                <li class="user-header bg-<?= ($settings['admin']['color'] ? $settings['admin']['color'] : ($settings['admin']['skin'] == 'black' ? $settings['admin']['skin'] : 'light-blue')) ?>">
                                    <img src="<?= ($BASE) ?><?= ($admin['photo'] ? '/'.$UPLOADS.$admin['photo'] : '/assets/img/avatar5.png') ?>" class="img-circle" alt="Imagem do Usuário" />
                                    <p>
                                        <?= ($admin['firstname']) ?> - <?= (ucfirst($admin['group']['description']))."
" ?>
                                        <small>Membro desde <?= (date('M, Y', strtotime($admin['created_on']))) ?></small>
                                    </p>
                                </li>
                                <!-- Menu Body -->
                                <li class="user-body">
                                    <div class="col-xs-4 text-center">
                                <?php if (\Hwapx\Core\Library\ModuleManager::instance()->hasRole('hwapx.admin.settings')): ?>
                                        <a href="<?= ($BASE) ?><?= (Base::instance()->alias('admin_settings')) ?>">Configurações</a>
                                <?php endif; ?>
                                    </div>
                                    <div class="col-xs-4 text-center">
                                        <!--<a href="#">Followers</a>-->
                                    </div>
                                    <div class="col-xs-4 text-center">
                                <?php if (\Hwapx\Core\Library\ModuleManager::instance()->hasRole('hwapx.logs.logs')): ?>
                                        <a href="<?= ($BASE) ?><?= (Base::instance()->alias('admin_logs')) ?>">Logs</a>
                                <?php endif; ?>
                                    </div>
                                </li>
                                <!-- Menu Footer-->
                                <li class="user-footer">
                                    <div class="pull-left">
                                        <a href="<?= ($BASE) ?><?= (Base::instance()->alias('admin_user_edit', 'id='.$SESSION['admin']['id'])) ?>" class="btn btn-default btn-flat"><span class="glyphicon glyphicon-user"></span> &nbsp;Perfil</a>
                                    </div>
                                    <div class="pull-right">
                                        <a href="<?= ($BASE) ?><?= (Base::instance()->alias('admin_logout')) ?>" class="btn btn-default btn-flat"><span class="glyphicon glyphicon-log-out"></span> &nbsp;Sair</a>
                                    </div>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas<?= ($settings['admin']['sidebar_color'] ? ' bg-'.$settings['admin']['sidebar_color'] : '') ?>">
                <!-- sidebar: style can be found in sidebar.less -->
                <section class="sidebar">
                    <!-- Sidebar user panel -->
                    <div class="user-panel">
                        <div class="pull-left image">
                            <img src="<?= ($BASE) ?><?= ($admin['photo'] ? '/'.$UPLOADS.$admin['photo'] : '/assets/img/avatar5.png') ?>" class="img-circle" alt="Imagem do Usuário" />
                        </div>
                        <div class="pull-left info">
                            <p>Olá <?= ($admin['firstname']) ?></p>
                            <a href="javascript:void(0);">
                                <span class="glyphicon glyphicon-tower"></span> <?= ($admin['group']['description'])."
" ?>
                            </a>
                        </div>
                    </div>
                    
                    <!-- sidebar menu: : style can be found in sidebar.less -->
                    <ul class="sidebar-menu">
                        <?php foreach (($_sidebar?:[]) as $slug=>$data): ?>
                            <?php if (\Hwapx\Core\Library\ModuleManager::instance()->hasRole($data['role'])): ?>
                                <?php $_has_childs = false;
                                    $_child_selected = false;
                                    foreach ($data as $key => $link):
                                        if((int)$key === $key && \Hwapx\Core\Library\ModuleManager::instance()->hasRole($link['role'])):
                                            $_has_childs = true;
                                            if(isset($link['route']) && (strpos($URI, $BASE.\Base::instance()->alias($link['route'])) === 0)):
                                                $_child_selected = true;
                                                break;
                                            endif;
                                        endif;
                                    endforeach;
                                    $_uri = $BASE.\Base::instance()->alias($data['route']);
                                    $_selected = isset($data['route']) && ($_uri === '/' ? $_uri === $URI : strpos($URI, $_uri) === 0) ? true  : false;
                                    $_showitem = $_has_childs || isset($data['route']); ?>
                                <?php if ($_showitem): ?>
                                <li class="<?= ($_has_childs ? 'treeview' : '') ?><?= ($_child_selected || $_selected ? ' active' : '') ?>">
                                    <a href="<?= (isset($data['route']) ? $_uri : 'javascript:void(0);') ?>">
                                        <?= (isset($data['icon']) ? '<i class="glyphicon glyphicon-'.$data['icon'].'"></i>' : '')."
" ?>
                                        <span><?= ($data['label']) ?></span>
                                        <?php if (isset($data['tip'])): ?>
                                            <small class="badge pull-right <?= (isset($data['tip']['color']) ? 'bg-'.$data['tip']['color'] : '') ?>"><?= (isset($data['tip']['label']) ? $data['tip']['label'] : $data['tip']) ?></small>
                                        <?php endif; ?>
                                        <?php if ($_has_childs): ?>
                                            <i class="glyphicon glyphicon-angle-<?= ($_child_selected ? 'down' : 'left') ?> pull-right"></i>
                                        <?php endif; ?>
                                    </a>
                                    <?php if ($_has_childs): ?>
                                        <ul class="treeview-menu<?= ($settings['admin']['sidebar_color'] ? ' bg-'.str_replace('-gradient', '', $settings['admin']['sidebar_color']) : '') ?>">
                                            <?php foreach (($data?:[]) as $key=>$link_data): ?>
                                                <?php if (((int)$key === $key) && \Hwapx\Core\Library\ModuleManager::instance()->hasRole($link_data['role'])): ?>
                                                    <?php $_uri = isset($link_data['route']) ? $BASE.\Base::instance()->alias($link_data['route']) : null ?>
                                                    <li class="<?= ($_uri && (strpos($URI, $_uri) === 0) ? 'active' : '') ?>">
                                                        <a href="<?= (isset($link_data['route']) ? $_uri : 'javascript:void(0);') ?>">
                                                            <i class="glyphicon glyphicon-<?= (isset($link_data['icon']) ? $link_data['icon'] : 'angle-double-right') ?>"></i>
                                                            <?= (isset($link_data['label']) ? $link_data['label'] : $link_data)."
" ?>

                                                            <?php if (isset($link_data['tip'])): ?>
                                                                <small class="badge pull-right <?= (isset($link_data['tip']['color']) ? 'bg-'.$link_data['tip']['color'] : '') ?>"><?= (isset($link_data['tip']['label']) ? $link_data['tip']['label'] : $link_data['tip']) ?></small>
                                                            <?php endif; ?>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; ?>
                        <!--
                        <li>
                            <a href="../../index.html">
                                <i class="glyphicon glyphicon-dashboard"></i> <span>Dashboard</span>
                            </a>
                        </li>
                        <li>
                            <a href="../widgets.html">
                                <i class="glyphicon glyphicon-th"></i> <span>Widgets</span> <small class="badge pull-right bg-green">new</small>
                            </a>
                        </li>
                        <li class="treeview">
                            <a href="#">
                                <i class="glyphicon glyphicon-bar-chart-o"></i>
                                <span>Charts</span>
                                <i class="glyphicon glyphicon-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="../charts/morris.html"><i class="glyphicon glyphicon-angle-double-right"></i> Morris</a></li>
                                <li><a href="../charts/flot.html"><i class="glyphicon glyphicon-angle-double-right"></i> Flot</a></li>
                                <li><a href="../charts/inline.html"><i class="glyphicon glyphicon-angle-double-right"></i> Inline charts</a></li>
                            </ul>
                        </li>
                        <li class="treeview">
                            <a href="#">
                                <i class="glyphicon glyphicon-laptop"></i>
                                <span>UI Elements</span>
                                <i class="glyphicon glyphicon-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="../UI/general.html"><i class="glyphicon glyphicon-angle-double-right"></i> General</a></li>
                                <li><a href="../UI/icons.html"><i class="glyphicon glyphicon-angle-double-right"></i> Icons</a></li>
                                <li><a href="../UI/buttons.html"><i class="glyphicon glyphicon-angle-double-right"></i> Buttons</a></li>
                                <li><a href="../UI/sliders.html"><i class="glyphicon glyphicon-angle-double-right"></i> Sliders</a></li>
                                <li><a href="../UI/timeline.html"><i class="glyphicon glyphicon-angle-double-right"></i> Timeline</a></li>
                            </ul>
                        </li>
                        <li class="treeview active">
                            <a href="#">
                                <i class="glyphicon glyphicon-edit"></i> <span>Forms</span>
                                <i class="glyphicon glyphicon-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li class="active"><a href="general.html"><i class="glyphicon glyphicon-angle-double-right"></i> General Elements</a></li>
                                <li><a href="advanced.html"><i class="glyphicon glyphicon-angle-double-right"></i> Advanced Elements</a></li>
                                <li><a href="editors.html"><i class="glyphicon glyphicon-angle-double-right"></i> Editors</a></li>
                            </ul>
                        </li>
                        <li class="treeview">
                            <a href="#">
                                <i class="glyphicon glyphicon-table"></i> <span>Tables</span>
                                <i class="glyphicon glyphicon-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="../tables/simple.html"><i class="glyphicon glyphicon-angle-double-right"></i> Simple tables</a></li>
                                <li><a href="../tables/data.html"><i class="glyphicon glyphicon-angle-double-right"></i> Data tables</a></li>
                            </ul>
                        </li>
                        <li>
                            <a href="../calendar.html">
                                <i class="glyphicon glyphicon-calendar"></i> <span>Calendar</span>
                                <small class="badge pull-right bg-red">3</small>
                            </a>
                        </li>
                        <li>
                            <a href="../mailbox.html">
                                <i class="glyphicon glyphicon-envelope"></i> <span>Mailbox</span>
                                <small class="badge pull-right bg-yellow">12</small>
                            </a>
                        </li>
                        <li class="treeview">
                            <a href="#">
                                <i class="glyphicon glyphicon-folder"></i> <span>Examples</span>
                                <i class="glyphicon glyphicon-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="../examples/invoice.html"><i class="glyphicon glyphicon-angle-double-right"></i> Invoice</a></li>
                                <li><a href="../examples/login.html"><i class="glyphicon glyphicon-angle-double-right"></i> Login</a></li>
                                <li><a href="../examples/register.html"><i class="glyphicon glyphicon-angle-double-right"></i> Register</a></li>
                                <li><a href="../examples/lockscreen.html"><i class="glyphicon glyphicon-angle-double-right"></i> Lockscreen</a></li>
                                <li><a href="../examples/404.html"><i class="glyphicon glyphicon-angle-double-right"></i> 404 Error</a></li>
                                <li><a href="../examples/500.html"><i class="glyphicon glyphicon-angle-double-right"></i> 500 Error</a></li>
                                <li><a href="../examples/blank.html"><i class="glyphicon glyphicon-angle-double-right"></i> Blank Page</a></li>
                            </ul>
                        </li>-->
                    </ul>
                </section>
                <!-- /.sidebar -->
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        <?= (isset($page['title']) ? $page['title'] : '')."
" ?>
                        <small><?= (isset($page['description']) ? $page['description'] : '') ?></small>
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="<?= ($BASE) ?><?= (Base::instance()->alias('admin_dashboard')) ?>"><i class="glyphicon glyphicon-dashboard"></i> Dashboard</a></li>
                    <?php if (!empty($breadcrumbs)): ?>
                        
                            <?php $counter=0; foreach (($breadcrumbs?:[]) as $route=>$desc): $counter++; ?>
                                <?php if (!is_numeric($route)): ?>
                                    
                                        <li><a href="<?= ($BASE) ?><?= (Base::instance()->alias($route)) ?>"><?= ($desc) ?></a></li>
                                    
                                    <?php else: ?>
                                        <li class="active"><?= ($desc) ?></li>
                                    
                                <?php endif; ?>
                            <?php endforeach; ?>
                        
                        <?php else: ?>
                            <li class="active"><?= ($page['title']) ?></li>
                        
                    <?php endif; ?>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo $this->render('hwapx/admin/admin/partials/flash.html',NULL,get_defined_vars(),0); ?>
                        </div>
                    </div>