<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
    <h4 class="modal-title" id="login-label">Entrar</h4>
</div>
<div class="modal-body">
    <div id="login-msg"></div>
    <div class="row login">
        <div class="col-md-6 login-text">
          Ainda não possui cadastro?<div class="login-text-break"></div>
          <a href="#" data-toggle="modal" data-target="#registrar">Cadastre-se</a> agora!
        </div>
        <form class="col-md-6" id="login-form">
            <div class="form-group">
                <label>Email:</label>
                <input type="email" class="form-control" name="email" required>
            </div>
            <div class="form-group">
                <label>Senha:</label>
                <input type="password" class="form-control" name="senha" required>
                <p class="help-block text-center"><a href="#" data-toggle="modal" data-target="#reset">Esqueci minha senha</a></p>
            </div>
        </form>
    </div>
</div>
<div class="modal-footer">
    <button type="submit" class="btn btn-success" form="login-form" id="login-btn">Entrar</button>
</div>

<div class="modal fade" id="reset" tabindex="-1" role="dialog" aria-labelledby="reset-label">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <?php echo $this->render('softsat/locacao/partials/reset.html',NULL,get_defined_vars(),0); ?>
        </div>
    </div>
</div>

<script>
$('#login-form').submit(function(evt) {
    evt.preventDefault();
    
    var $frm = $(this);
    var $btn = $('#login-btn');
    var $msg = $('#login-msg');
    
    $btn.prop('disabled', true);
    $msg.removeAttr('class').text('');
    
    $.post('<?= (Base::instance()->alias("softsat_locacao_login")) ?>', $frm.serialize(), function(resp) {
        if(resp.error) {
            $msg.text(resp.message).attr('class', 'alert alert-danger');
            return;
        }
        
        $('#conta-link').text('Olá ' + resp.data.nick).removeClass('hidden');
        $('#login-link').addClass('hidden');
        $('#login').modal('hide');
        $frm.find('input').val('');
    }, 'json').fail(function() {
        alert('Falha na requisição, contate o administrador');
    }).always(function() {
        $btn.prop('disabled', false);
    });
    
    return false;
});
</script>
