<!DOCTYPE html>
<html lang="pt-BR">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="keywords" content="Locadora de Carro, Aluguel de carro, Rent a car, aluguel de veiculo, locadora de veiculo, carro para alugar, como alugar um carro, preço de aluguel de carro, alugar carro barato, locar carro" />

        <!-- <link rel="shortcut icon" href="images/star.png" type="favicon/ico" /> -->
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <!--<script async src="https://www.googletagmanager.com/gtag/js?id=UA-109291772-1"></script>
        <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());

          gtag('config', 'UA-109291772-1');
        </script>-->

        <title>W.Location</title>

        <link rel="stylesheet" href="assets/site/css/bootstrap.min.css">
        <!--<link rel="stylesheet" href="assets/site/css/font-awesome.min.css">-->
        <link rel="stylesheet" href="assets/site/css/owl.carousel.css">
        <link rel="stylesheet" href="assets/site/css/owl.theme.css">
        <!--<link rel="stylesheet" href="assets/site/css/animate.css">
        <link rel="stylesheet" href="assets/site/css/flexslider.css">-->
        <link rel="stylesheet" href="assets/site/css/pricing.css">
        <link rel="stylesheet" href="assets/site/css/main.css">

        <script src="assets/site/js/jquery-1.11.2.min.js"></script>
        <!--<script src="assets/site/js/jquery.flexslider.min.js"></script>
        <script>
            $(window).load(function() {
                $('.flexslider').flexslider({
                 animation: "slide",
                 controlsContainer: ".flexslider-container"
                });
            });
        </script>-->

        <!--<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCeF3jYhKuz5U3rhg0xBZBfGwB2EpatZdY"></script>
        <script>
            function initialize() {
                var mapCanvas = document.getElementById('map-canvas');
                var mapOptions = {
                    center: new google.maps.LatLng(-21.0661933,-49.675032),
                    zoom: 16,
                    scrollwheel: false,
                    mapTypeId: google.maps.MapTypeId.ROADMAP
                }
                var map = new google.maps.Map(mapCanvas, mapOptions)

                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(-21.0661933,-49.675032),
                    title:"W.Location | Aluguel de Carros"
                });

                // To add the marker to the map, call setMap();
                marker.setMap(map);
            }
            google.maps.event.addDomListener(window, 'load', initialize);
        </script>-->
    </head>
    <body data-spy="scroll" data-target="#template-navbar">

        <!--== 4. Navigation ==-->
        <nav id="template-navbar" class="navbar navbar-default custom-navbar-default navbar-fixed-top">
            <div class="container">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#Food-fair-toggle">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="#">
                        <img id="logo" src="assets/site/images/Logo_main.png" class="logo img-responsive">
                    </a>
                </div>

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse" id="Food-fair-toggle">
                    <ul class="nav navbar-nav navbar-right">
                        <li><a href="#about">Sobre</a></li>
                        <li><a href="#reserve">Reservas</a></li>
                        <li><a href="#contact">Contato</a></li>
                        <li class="hidden-sm hidden-xs"><a>|</a></li>
                        <li class="dropdown">
                            <a href="#" data-toggle="modal" data-target="#login" id="login-link" class="<?= ($cliente ? 'hidden' : '') ?>">Entrar</a>
                            <a href="#" class="dropdown-toggle <?= ($cliente ? '' : 'hidden') ?>" id="conta-link" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                Olá <?= ($cliente ? $cliente['nick'] : '')."
" ?>
                                <span class="caret"></span>
                            </a>
                            <ul class="dropdown-menu">
                                <li><a href="<?= (Base::instance()->alias('softsat_locacao_conta')) ?>" data-toggle="modal" data-target="#conta">Meus dados</a></li>
                                <li><a href="<?= (Base::instance()->alias('softsat_locacao_historico')) ?>" data-toggle="modal" data-target="#historico">Histórico</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?= (Base::instance()->alias('softsat_locacao_logout')) ?>">Sair</a></li>
                            </ul>
                        </li>
                    </ul>
                </div><!-- /.navbar-collapse -->
            </div><!-- /.row -->
        </nav>

        <!--== 5. Header ==-->
        <section id="header-slider" class="owl-carousel">
            <div class="item">
                <div class="container">
                    <div class="header-content">
                        <h1 class="header-title">W.Location</h1>
                        <p class="header-sub-title">Aluguel de Carros</p>
                    </div> <!-- /.header-content -->
                </div>
            </div>
            <div class="item">
                <div class="container">
                    <div class="header-content">
                        <h1 class="header-title">W.Location</h1>
                        <p class="header-sub-title">Aluguel de Carros</p>
                    </div> <!-- /.header-content -->
                </div>
            </div>
            <div class="item">
                <div class="container">
                    <div class="header-content text-right pull-right">
                        <h1 class="header-title">W.Location</h1>
                        <p class="header-sub-title">Aluguel de Carros</p>
                    </div> <!-- /.header-content -->
                </div>
            </div>
        </section>

        <!--== 6. About us ==-->
        <section id="about" class="about">
            <img src="assets/site/images/icons/about_color.png" class="img-responsive section-icon hidden-sm hidden-xs">
            <div class="wrapper">
                <div class="container-fluid">
                    <div class="row dis-table">
                        <div class="hidden-xs col-sm-6 section-bg about-bg dis-table-cell">

                        </div>
                        <div class="col-xs-12 col-sm-6 dis-table-cell">
                            <div class="section-content">
                                <h2 class="section-content-title">A W.Location</h2>
                                <p class="section-content-para">
                                    <b>Sem surpresas ou burocracias.</b>
                                </p>
                                <p class="section-content-para">
                                    Nossa política de preços te ajudará a não perder tempo procurando pela sua próxima locação.
                                    Na W.Location nós temos as melhores tarifas da região.
                                </p>
                                <p class="section-content-para">
                                    Nossa frota é composta por carros novos e revisados constantemente, garantindo conforto e segurança para nossos clientes.
                                </p>
                            </div> <!-- /.section-content -->
                        </div>
                    </div> <!-- /.row -->
                </div> <!-- /.container-fluid -->
            </div> <!-- /.wrapper -->
        </section> <!-- /#about -->

        <!--== 15. Reserve A Table! ==-->
        <section id="reserve" class="reserve pricing-filter">
            <div class="wrapper pricing-filter-wrapper">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xs-12 col-md-6 color-bg">
                            <h2 class="section-title">Reserve seu carro !</h2>
                        </div>
                        <div class="col-xs-12 col-md-6">
                            <div class="row">
                                <form class="col-sm-8 col-sm-offset-2 col-md-12 col-md-offset-0 col-lg-10 col-lg-offset-1 filter-form">
                                    <div class="form-group">
                                        <label class="col-md-4 text-right">Saída:</label>
                                        <div class="col-md-8">
                                            <select class="form-control" name="local_saida">
                                            <?php foreach (($locais?:[]) as $local): ?>
                                                <option value="<?= ($local['id']) ?>"><?= ($local['nome']) ?></option>
                                            <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-md-4 text-right">Data:</label>
                                        <div class="col-md-8">
                                            <div class="input-group" id="dt_saida">
                                                <input class="form-control date" type="text" name="saida" required="required" value="<?= (date('d/m/Y H:i:00')) ?>">
                                                <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>
                                    <div class="form-group">
                                            <label class="col-md-4 text-right">Retorno:</label>
                                            <div class="col-md-8">
                                                <select class="form-control" name="local_entrada">
                                                <?php foreach (($locais?:[]) as $local): ?>
                                                    <option value="<?= ($local['id']) ?>"><?= ($local['nome']) ?></option>
                                                <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="clearfix"></div>
                                        </div>
                                    <div class="form-group">
                                        <label class="col-md-4 text-right">Data:</label>
                                        <div class="col-md-8">
                                            <div class="input-group" id="dt_entrada">
                                                <input class="form-control" type="text" name="entrada" required="required" value="<?= (date('d/m/Y H:i:00', strtotime('+1 day'))) ?>">
                                                <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-md-4 text-right">Marca:</label>
                                        <div class="col-md-8">
                                            <select class="form-control" name="marca">
                                                <option value="">Todas</option>
                                                <?php foreach (($marcas?:[]) as $marca): ?>
                                                    <option value="<?= ($marca['id']) ?>"><?= ($marca['nome']) ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-offset-4 col-md-8">
                                            <button type="submit" class="btn btn-send btn-consultar">Consultar veículos disponíveis</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div> <!-- /.dis-table -->
                </div> <!-- /.row -->
            </div> <!-- /.wrapper -->
        </section> <!-- /#reserve -->

        <!--==  7. Afordable Pricing  ==-->
        <section id="pricing" class="pricing">
            <div id="w">
                <div class="container">
                    <div class="row">
                        <div class="col-md-10 col-md-offset-1">
                            <div class="text-center loader hidden"><img src="assets/site/images/loading.gif" alt="Carregando..." style="margin: 24%;"></div>
                            <div id="menu-pricing" class="menu-price row">
                                <?php $params = array(
                                    'saida' => date('d/m/Y H:i:00'), 
                                    'entrada' => date('d/m/Y H:i:00', strtotime('+1 day')), 
                                    'local_saida' => $settings['softsat']['locacao']['contrato']['local_saida_id'], 
                                    'local_entrada' => $settings['softsat']['locacao']['contrato']['local_entrada_id']) ?>
                                <?php echo $this->render('softsat/locacao/partials/veiculos.html',NULL,get_defined_vars(),0); ?>
                            </div>
                            <script>
                            $(document).ready(function() {
                                $('#dt_saida').datetimepicker({
                                    useCurrent: true,
                                    format: 'DD/MM/YYYY HH:mm:00',
                                    minDate: '<?= (date("Y-m-d H:i:00")) ?>'
                                    //maxDate: '<?= (date("Y-m-d")) ?>'
                                });
                                $('#dt_entrada').datetimepicker({
                                    useCurrent: false,
                                    format: 'DD/MM/YYYY HH:mm:00',
                                    minDate: '<?= (date("Y-m-d H:i:00", strtotime("+1 day"))) ?>'
                                });
                                $("#dt_saida").on("dp.change", function (e) {
                                    $('#dt_entrada').data("DateTimePicker").minDate(e.date.add('days', 1));
                                });
                                $("#dt_entrada").on("dp.change", function (e) {
                                    $('#dt_saida').data("DateTimePicker").maxDate(e.date.add('days', -1));
                                });
                            });

                            (function() {
                                var f = function(evt) {
                                    evt.preventDefault();

                                    var $frm = $(this);
                                    var $btn = $(this).find('button');
                                    var $ldr = $('.loader').removeClass('hidden');
                                    var params = $frm.data('params') || $frm.serialize();

                                    $btn.prop('disabled', true);
                                    $('#menu-pricing').empty();

                                    $.get('<?= (Base::instance()->alias("softsat_locacao_veiculos")) ?>', params, function(resp) {
                                        $('#menu-pricing').html(resp);
                                    }).fail(function() {
                                        alert('Falha na requisição, contate o administrador');
                                    }).always(function() {
                                        $btn.prop('disabled', false);
                                        $ldr.addClass('hidden');
                                    });

                                    return false;
                                };
                                
                                $('.filter-form').submit(f);
                                $('#menu-pricing').on('click', '.veiculo-pagina', f);
                            })();
                            
                            $('#menu-pricing').on('click', '.reservar-veiculo', function(evt) {
                                evt.preventDefault();
                                
                                var $frm = $(this.form);
                                var $btn = $(this);
                                var $msg = $($btn.data('msg'));
                                
                                $btn.prop('disabled', true);
                                $msg.removeAttr('class').text('');
                                
                                $.post('<?= (Base::instance()->alias("softsat_locacao_reservar")) ?>', $frm.serialize(), function(resp) {
                                    if(resp.login) {
                                        $('#login').modal('show');
                                        return;
                                    }
                                    
                                    $msg.attr('class', resp.error ? 'alert alert-danger' : 'alert alert-success')
                                        .text(resp.message);
                                }, 'json').fail(function() {
                                    alert('Falha na requisição, contate o administrador');  
                                }).always(function() {
                                    $btn.prop('disabled', false); 
                                });
                                
                                return false;
                            });
                            </script>
                        </div>   
                    </div>
                </div>
            </div> 
        </section>

        <section id="contact" class="contact">
            <div class="container-fluid color-bg">
                <div class="row dis-table">
                    <div class="hidden-xs col-sm-6 dis-table-cell">
                        <h2 class="section-title">Fale com a gente!</h2>
                    </div>
                    <div class="col-xs-6 col-sm-6 dis-table-cell">
                        <div class="section-content">
                            <p>AV. Joaquim Moreira da Silva, 2650</p>
                            <p>+55 17 3245-2127</p>
                            <p>contato@wlocation.com.br </p>
                        </div>
                    </div>
                </div>
                <div class="social-media dis-table">
                    <div class="row">
                        <div class="col-md-6 col-md-offset-3 text-center">
                                <a href="https://www.facebook.com/wlocation/" class="fb" style="display: inline-block;float:none;"></a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="container-fluid">
            <div class="row">
                <div id="map-canvas"></div>
            </div>
        </div>

        <section class="contact-form">
            <div class="container">
                <div class="row">
                    <div class="col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1">
                        <div class="row">
                            <?php echo $this->render('softsat/locacao/partials/contato.html',NULL,get_defined_vars(),0); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <footer>
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-md-offset-3">
                        <div class="copyright text-center">
                            <p>
                                &copy; Copyright, 2017-<?= (date('Y')) ?> <a href="#">W.Location</a> <!-- Feito por: <a href="http://softsat.com.br/"  target="_blank">Softsat</a> -->
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        
        <div class="modal fade" id="login" tabindex="-1" role="dialog" aria-labelledby="login-label">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <?php echo $this->render('softsat/locacao/partials/login.html',NULL,get_defined_vars(),0); ?>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="registrar" tabindex="-1" role="dialog" aria-labelledby="registrar-label">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <?php echo $this->render('softsat/locacao/partials/register.html',NULL,get_defined_vars(),0); ?>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="historico" tabindex="-1" role="dialog" aria-labelledby="historico-label">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content"></div>
            </div>
        </div>
        
        <div class="modal fade" id="conta" tabindex="-1" role="dialog" aria-labelledby="conta-label">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content"></div>
            </div>
        </div>
        
        <?php if (isset($redefinir)): ?>
        <div class="modal" id="reset2" tabindex="-1" role="dialog" aria-labelledby="reset2-label">
            <div class="modal-dialog modal-md" role="document">
                <div class="modal-content">
                    <?php echo $this->render('softsat/locacao/partials/reset2.html',NULL,['redefinir'=>$redefinir]+get_defined_vars(),0); ?>
                </div>
            </div>
        </div>
        
        <script>
            $(document).ready(function() {
                $('#reset2').modal('show');
            });
        </script>
        <?php endif; ?>
        
        <link href="assets/css/bootstrap-datetimepicker.min.css" rel="stylesheet">

        <script src="assets/site/js/bootstrap.min.js"></script>
        <script src="assets/site/js/owl.carousel.min.js"></script>
        <!--<script src="assets/site/js/jquery.mixitup.min.js" ></script>
        <script src="assets/site/js/wow.min.js"></script>
        <script src="assets/site/js/jquery.validate.js"></script>
        <script src="assets/site/js/jquery.hoverdir.js"></script>-->
        <script src="assets/site/js/jQuery.scrollSpeed.js"></script>
        <script src="assets/js/moment.js"></script>
        <script src="assets/js/bootstrap-datetimepicker.min.js"></script>
        <script src="assets/site/js/script.js"></script>
    </body>
</html>
