<div id="contact-msg"></div>

<form class="contact-form" method="post" action="<?= (Base::instance()->alias('softsat_locacao_contato')) ?>">
    <div class="col-md-6 col-sm-6">
        <div class="form-group">
            <input  name="nome" type="text" class="form-control" id="name" required="required" placeholder="  Nome">
        </div>
        <div class="form-group">
            <input name="email" type="email" class="form-control" id="email" required="required" placeholder="  Email">
        </div>
        <div class="form-group">
            <input name="assunto" type="text" class="form-control" id="subject" required="required" placeholder="  Assunto">
        </div>
    </div>

    <div class="form-group col-md-6 col-sm-6">
        <textarea name="mensagem" type="text" class="form-control" id="message" rows="7" required="required" placeholder="  Mensagem"></textarea>
    </div>

    <div class="col-md-6 col-md-offset-3 col-sm-6 col-sm-offset-3">
        <div class="text-center">
            <button type="submit" id="submit" name="submit" class="btn btn-send">Enviar </button>
        </div>
    </div>
</form>

<script>
$('.contact-form').submit(function(evt) {
    evt.preventDefault();
        
    var $frm = $(this);
    var data = $frm.serialize();
    var $msg = $('#contact-msg');
    var $btn = $frm.find('button').prop('disabled', true).text('Enviando...');

    $frm.find('.form-group').removeClass('has-error');
        
    $.post($frm.attr('action'), data, function(resp) {
        $msg.attr('class', resp.error ? 'alert alert-danger' : 'alert alert-success')
            .text(resp.message);

        if(resp.error) {
            for(var key in resp.fields) {
                $frm.find('[name=' + key + ']')
                    .parent()
                    .addClass('has-error');
                
                $msg.append('<br>' + resp.fields[key]);
            }
        }
            
        if(!resp.error)
            $frm.find('input,textarea').val('');
    }, 'json').fail(function() {
        alert('Falha na requisição, contate o administrador.');
    }).always(function() {
        $btn.prop('disabled', false).text('Enviar');
    });
    
    return false;
});
</script>