<?php foreach (($veiculos['items']?:[]) as $veiculo): ?>
    <div class="col-md-4 col-sm-6">
        <div class="item">
          <a class="veiculo" href="#" data-toggle="modal" data-target="#veiculo-<?= ($veiculo['id']) ?>">
              <?php if ($veiculo['imagem']): ?>
                  
                      <img src="<?= (\Base::instance()->call($this->filter('resize'),[$veiculo['imagem'],680,440,true,true])) ?>" class="img-responsive" alt="<?= ($veiculo['marca']) ?> <?= ($veiculo['modelo']) ?>">
                  
                  <?php else: ?>
                      <img src="assets/img/sem-imagem.jpg" class="img-responsive" alt="<?= ($veiculo['marca']) ?> <?= ($veiculo['modelo']) ?>">
                  
              <?php endif; ?>
              <div class="menu-desc">
                  <span>
                      <h3><?= ($veiculo['marca']) ?> <?= ($veiculo['modelo']) ?></h3>
                      <?= ($veiculo['grupo'])."
" ?>
                  </span>
              </div>
          </a>
          <h2 class="white">
                <?php switch ($settings['softsat']['locacao']['site']['exibir_valor']): ?><?php case 'diaria': ?>
                    <?= ($veiculo['diaria'] > 0 ? 'R$ ' . number_format($veiculo['diaria'], 2, ',', '.') . ' / dia' : 'Consulte')."
" ?>
                <?php break; ?><?php default: ?>
                    Reservar
                <?php break; ?><?php endswitch; ?>
            </h2>
        </div>
        <div class="modal fade" id="veiculo-<?= ($veiculo['id']) ?>" tabindex="-1" role="dialog" aria-labelledby="veiculo-<?= ($veiculo['id']) ?>-label">
            <div class="modal-dialog modal-md" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="veiculo-<?= ($veiculo['id']) ?>-label">Confirmar reserva</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php if ($veiculo['imagem']): ?>
                                    
                                        <img src="<?= (\Base::instance()->call($this->filter('resize'),[$veiculo['imagem'],680,440,true,true])) ?>" class="img-responsive" alt="<?= ($veiculo['marca']) ?> <?= ($veiculo['modelo']) ?>">
                                    
                                    <?php else: ?>
                                        <img src="assets/img/sem-imagem.jpg" class="img-responsive" alt="<?= ($veiculo['marca']) ?> <?= ($veiculo['modelo']) ?>">
                                    
                                <?php endif; ?>
                                </div>
                            <div class="col-md-6">
                                <form id="reservar-veiculo-<?= ($veiculo['id']) ?>">
                                    <input type="hidden" name="local_saida" value="<?= ($params['local_saida']) ?>">
                                    <input type="hidden" name="saida" value="<?= ($params['saida']) ?>">
                                    <input type="hidden" name="local_entrada" value="<?= ($params['local_entrada']) ?>">
                                    <input type="hidden" name="entrada" value="<?= ($params['entrada']) ?>">
                                    <input type="hidden" name="veiculo" value="<?= ($veiculo['id']) ?>">
                                </form>
                                <?php if ($params['saida'] == $params['entrada']): ?>
                                    Reservar o <?= ($veiculo['marca']) ?> <?= ($veiculo['modelo']) ?> <br>para o dia <?= (\Base::instance()->call($this->filter('date'),[$params['saida']])) ?>?
                                <?php endif; ?>
                                <?php if ($params['saida'] != $params['entrada']): ?>
                                    Reservar o <?= ($veiculo['marca']) ?> <?= ($veiculo['modelo']) ?> <br>de <?= (\Base::instance()->call($this->filter('date'),[$params['saida']])) ?> até <?= (\Base::instance()->call($this->filter('date'),[$params['entrada']])) ?>?
                                <?php endif; ?>
                            </div>
                        </div>
                        <div id="msg-veiculo-<?= ($veiculo['id']) ?>" style="margin: 0"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" data-msg="#msg-veiculo-<?= ($veiculo['id']) ?>" class="btn btn-success reservar-veiculo" form="reservar-veiculo-<?= ($veiculo['id']) ?>">Confirmar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; ?>
<?php if (!$veiculos['items']): ?>
    <div class="col-md-12 text-center">
        <div class="alert alert-warning">
          <?php if ($params['marca']): ?>
              Nenhum veículo da marca selecionada disponível no período informado!
          <?php endif; ?>
          <?php if (!$params['marca']): ?>
              Nenhum veículo disponível com no período informado!
          <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
<?php if ($veiculos['paginas'] > 1): ?>
<div class="clearfix"></div>
<div class="col-md-12">
<nav aria-label="Paginação">
  <ul class="pagination">
    <!--<li>
      <a href="#" aria-label="Anterior">
        <span aria-hidden="true">&laquo;</span>
      </a>
    </li>-->
    <?php for($i = 1; $i <= $veiculos['paginas']; $i++): ?>
    <?php $params['pagina'] = $i ?>
    <li class="<?= ($i == $veiculos['pagina'] ? 'active' : '') ?>"><a class="veiculo-pagina" href="<?= (Base::instance()->alias('softsat_locacao_veiculos')) ?>/<?= ($i) ?>" data-params="<?= (htmlentities(json_encode($params))) ?>"><?= ($i) ?></a></li>
    <?php endfor; ?>
    <!--<li>
      <a href="#" aria-label="Próximo">
        <span aria-hidden="true">&raquo;</span>
      </a>
    </li>-->
  </ul>
</nav>
</div>
<?php endif; ?>
